Ext.data.JsonP.sol_common_TranslateTerms({"tagname":"class","name":"sol.common.TranslateTerms","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.TranslateTerms.js","href":"lib_sol.common.TranslateTerms.html#sol-common-TranslateTerms"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloix":true,"eloas":true,"requires":["sol.common.Cache","sol.common.ObjectUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addLang","tagname":"method","owner":"sol.common.TranslateTerms","id":"method-addLang","meta":{"private":true}},{"name":"filterPrefixes","tagname":"method","owner":"sol.common.TranslateTerms","id":"method-filterPrefixes","meta":{"private":true}},{"name":"getLangs","tagname":"method","owner":"sol.common.TranslateTerms","id":"method-getLangs","meta":{"private":true}},{"name":"getTerm","tagname":"method","owner":"sol.common.TranslateTerms","id":"method-getTerm","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"rememberPrefixes","tagname":"method","owner":"sol.common.TranslateTerms","id":"method-rememberPrefixes","meta":{"private":true}},{"name":"require","tagname":"method","owner":"sol.common.TranslateTerms","id":"method-require","meta":{}},{"name":"translate","tagname":"method","owner":"sol.common.TranslateTerms","id":"method-translate","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.TranslateTerms","short_doc":"Cache for Translate Terms. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.TranslateTerms</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Cache' rel='sol.common.Cache' class='docClass'>sol.common.Cache</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.TranslateTerms.html#sol-common-TranslateTerms' target='_blank'>lib_sol.common.TranslateTerms.js</a></div></pre><div class='doc-contents'><p>Cache for Translate Terms. This class handles localization in Business Solutions.</p>\n\n<p>Property files should be placed in <code>Administration\\Localization\\</code>.</p>\n\n<p>ELO internal projects must use <code>Administration\\Localization\\system</code>. Modifications and Partner implementations must\nuse <code>Administration\\Localization\\custom</code>.</p>\n\n<h1>Using localization in scripts</h1>\n\n<p>Thanks to a require function call all required translation terms will get loaded in the cache. This must be done\nbefore terms are used by scripts. Following example shows a common usage for a dynamic keyword list.</p>\n\n<p>A property file must be located in the localization folder. e.g. <code>Administration\\Localization\\system\\sol.invoice.locale.properties</code></p>\n\n<pre><code>sol.invoice.dynkwl.Company.ID=Company id\nsol.invoice.dynkwl.Company.NAME=Company name\nsol.invoice.dynkwl.Company.CITY=City\n</code></pre>\n\n<p>The TranslateTerms utilizes the use of translation keys.</p>\n\n<pre><code><a href=\"#!/api/sol.common.TranslateTerms-method-require\" rel=\"sol.common.TranslateTerms-method-require\" class=\"docClass\">sol.common.TranslateTerms.require</a>('sol.invoice.dynkwl.Company');\n\nvar tableHeaders = [\n  <a href=\"#!/api/sol.common.TranslateTerms-method-translate\" rel=\"sol.common.TranslateTerms-method-translate\" class=\"docClass\">sol.common.TranslateTerms.translate</a>('sol.invoice.dynkwl.Company.ID'),\n  <a href=\"#!/api/sol.common.TranslateTerms-method-translate\" rel=\"sol.common.TranslateTerms-method-translate\" class=\"docClass\">sol.common.TranslateTerms.translate</a>('sol.invoice.dynkwl.Company.NAME'),\n  <a href=\"#!/api/sol.common.TranslateTerms-method-translate\" rel=\"sol.common.TranslateTerms-method-translate\" class=\"docClass\">sol.common.TranslateTerms.translate</a>('sol.invoice.dynkwl.Company.CITY')];\n</code></pre>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addLang' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.TranslateTerms'>sol.common.TranslateTerms</span><br/><a href='source/lib_sol.common.TranslateTerms.html#sol-common-TranslateTerms-method-addLang' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.TranslateTerms-method-addLang' class='name expandable'>addLang</a>( <span class='pre'>language</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Adds a language ...</div><div class='long'><p>Adds a language</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>language</span> : String<div class='sub-desc'><p>Language</p>\n</div></li></ul></div></div></div><div id='method-filterPrefixes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.TranslateTerms'>sol.common.TranslateTerms</span><br/><a href='source/lib_sol.common.TranslateTerms.html#sol-common-TranslateTerms-method-filterPrefixes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.TranslateTerms-method-filterPrefixes' class='name expandable'>filterPrefixes</a>( <span class='pre'>prefixes</span> ) : String[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks which prefixes have already been loaded. ...</div><div class='long'><p>Checks which prefixes have already been loaded.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>prefixes</span> : String[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLangs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.TranslateTerms'>sol.common.TranslateTerms</span><br/><a href='source/lib_sol.common.TranslateTerms.html#sol-common-TranslateTerms-method-getLangs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.TranslateTerms-method-getLangs' class='name expandable'>getLangs</a>( <span class='pre'>[additionalLanguage]</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the system languages ...</div><div class='long'><p>Retrieves the system languages</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>additionalLanguage</span> : String (optional)<div class='sub-desc'><p>Additional language</p>\n</div></li></ul></div></div></div><div id='method-getTerm' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.TranslateTerms'>sol.common.TranslateTerms</span><br/><a href='source/lib_sol.common.TranslateTerms.html#sol-common-TranslateTerms-method-getTerm' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.TranslateTerms-method-getTerm' class='name expandable'>getTerm</a>( <span class='pre'>language, key, [requestedTerm]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Get a translation for a key by a given language code. ...</div><div class='long'><p>Get a translation for a key by a given language code.</p>\n\n<pre><code>sol.common.TranslationTerms.getTerm('de', sol.contract.ix.client');\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>language</span> : String|de.elo.ix.client.ClientInfo<div class='sub-desc'><p>Either an ISO language String, or an de.elo.ix.client.ClientInfo Object</p>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'><p>The key in the resource files</p>\n</div></li><li><span class='pre'>requestedTerm</span> : boolean (optional)<div class='sub-desc'><p>if not set, function requests term if not in list.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>result The value of the key</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-rememberPrefixes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.TranslateTerms'>sol.common.TranslateTerms</span><br/><a href='source/lib_sol.common.TranslateTerms.html#sol-common-TranslateTerms-method-rememberPrefixes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.TranslateTerms-method-rememberPrefixes' class='name expandable'>rememberPrefixes</a>( <span class='pre'>prefixes</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Saves the prefixes that have been loaded, to avoid repeated requests. ...</div><div class='long'><p>Saves the prefixes that have been loaded, to avoid repeated requests.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>prefixes</span> : String[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-require' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.TranslateTerms'>sol.common.TranslateTerms</span><br/><a href='source/lib_sol.common.TranslateTerms.html#sol-common-TranslateTerms-method-require' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.TranslateTerms-method-require' class='name expandable'>require</a>( <span class='pre'>prefixes, [additionalLanguage]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads a list of translation keys by a given prefix. ...</div><div class='long'><p>Loads a list of translation keys by a given prefix.\nPrefixes can be either passed as an array or string.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>prefixes</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>additionalLanguage</span> : String (optional)<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-translate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.TranslateTerms'>sol.common.TranslateTerms</span><br/><a href='source/lib_sol.common.TranslateTerms.html#sol-common-TranslateTerms-method-translate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.TranslateTerms-method-translate' class='name expandable'>translate</a>( <span class='pre'>key</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Translates a key to the current language ...</div><div class='long'><p>Translates a key to the current language</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>The key in the resource files</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>result The translated key</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"singleton":true}});